import json
import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem

logger = logging.getLogger(__name__) 

SUB_PARTITION_DIRECTORY_DESCRIPTOR_TYPES_JSON = 'layout/sub_partition_directory_descriptor_types.json'

entry_types = {}

try:
    with open(SUB_PARTITION_DIRECTORY_DESCRIPTOR_TYPES_JSON) as sub_partition_directory_descriptor_types_json:
        sub_partition_directory_descriptor_types = json.load(sub_partition_directory_descriptor_types_json)
except IOError:
    logger.exception('sub partition descriptor types file does not exist')
    raise IOError('sub partition descriptor types file does not exist')

class SubPartitionDirectoryDescriptor(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START SubPartitionDirectoryDescriptor.__init__ FUNCTION')
        
        super(SubPartitionDirectoryDescriptor, self).__init__(data, **kwargs)
        self.set_sub_partition_directory_descriptor_attributes(
            kwargs['type'], kwargs['sub_partition_offset'], kwargs['sub_partition_size'])

    def set_sub_partition_directory_descriptor_attributes(self, set_sub_partition_directory_descriptor_type, sub_partition_offset, sub_partition_size):
        set_sub_partition_directory_descriptor_type = DataItem(
            self.value, **set_sub_partition_directory_descriptor_type)
        try:
            self.type = sub_partition_directory_descriptor_types[set_sub_partition_directory_descriptor_type.hex_value()]
        except KeyError:
            self.type= None
            logger.warning('sub partition does not been identified')
        self.sub_partition_offset = DataItem(
            self.value, **sub_partition_offset)
        self.sub_partition_size = DataItem(
            self.value, **sub_partition_size)
